/*! addEventListener Polyfill ie9- http://stackoverflow.com/a/27790212*/
window.addEventListener = window.addEventListener || function(a, b) {
        window.attachEvent("on" + a, b)
    }, /*!  Datenow Polyfill ie9- https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/now */
    Date.now || (Date.now = function() {
        return (new Date).getTime()
    }), /*! Object.create monkey patch ie8 http://stackoverflow.com/a/18020326 */
    Object.create || (Object.create = function(a, b) {
        function c() {}
        if ("undefined" != typeof b) throw "The multiple-argument version of Object.create is not provided by this browser and cannot be shimmed.";
        return c.prototype = a, new c
    }), /*! https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter */
    Array.prototype.filter || (Array.prototype.filter = function(a) {
        "use strict";
        if (void 0 === this || null === this) throw new TypeError;
        var b = Object(this),
            c = b.length >>> 0;
        if ("function" != typeof a) throw new TypeError;
        for (var d = [], e = arguments.length >= 2 ? arguments[1] : void 0, f = 0; f < c; f++)
            if (f in b) {
                var g = b[f];
                a.call(e, g, f, b) && d.push(g)
            }
        return d
    }), /*! map was added to the ECMA-262 standard in the 5th edition */
    Array.prototype.map || (Array.prototype.map = function(a, b) {
        var c, d, e;
        if (null === this) throw new TypeError(" this is null or not defined");
        var f = Object(this),
            g = f.length >>> 0;
        if ("function" != typeof a) throw new TypeError(a + " is not a function");
        for (arguments.length > 1 && (c = b), d = new Array(g), e = 0; e < g;) {
            var h, i;
            e in f && (h = f[e], i = a.call(c, h, e, f), d[e] = i), e++
        }
        return d
    }),
    function(a, b, c, d) {
        function e(b, c) {
            var e = a(b).attr(c);
            return typeof e !== d && e
        }
        var f = "original",
            g = ["Width", "Height"];
        g.map(function(b) {
            var c = b.toLowerCase();
            a.fn[f + b] = "natural" + b in new Image ? function() {
                return this[0]["natural" + b]
            } : function() {
                var a = e(this, c);
                if (a) return a;
                var b, d = this[0];
                return "img" === d.tagName.toLowerCase() && (b = new Image, b.src = d.src, a = b[c]), a
            }
        })
    }(jQuery, window, document),
    function(a, b, c, d) {
        function e(b, c) {
            this.element = b, this.options = a.extend({}, g, c), this._defaults = g, this._name = f, this.init()
        }
        var f = "imgSmartLoad",
            g = {
                load_all_images_on_first_scroll: !1,
                attribute: ["data-src", "data-srcset"],
                excludeImg: "",
                threshold: 200,
                fadeIn_options: {
                    duration: 400
                },
                delaySmartLoadEvent: 0
            };
        e.prototype.init = function() {
            var c = this,
                d = a("img[" + this.options.attribute[0] + "]:not(" + this.options.excludeImg.join() + ")", this.element);
            this.increment = 1, this.timer = 0, d.bind("load_img", {}, function() {
                c._load_img(this)
            }), a(b).scroll(function(a) {
                c._better_scroll_event_handler(d, a)
            }), a(b).resize(function(a) {
                c._maybe_trigger_load(d, a)
            }), this._maybe_trigger_load(d)
        }, e.prototype._better_scroll_event_handler = function(a, c) {
            var d = this;
            0 !== this.timer && (this.increment++, b.clearTimeout(this.timer)), this.timer = b.setTimeout(function() {
                d._maybe_trigger_load(a, c)
            }, d.increment > 5 ? 50 : 0)
        }, e.prototype._maybe_trigger_load = function(b, c) {
            var d = this;
            _visible_list = b.filter(function(a, b) {
                return d._is_visible(b, c)
            }), _visible_list.map(function(b, c) {
                a(c).trigger("load_img")
            })
        }, e.prototype._is_visible = function(c, d) {
            var e = a(c),
                f = a(b).scrollTop(),
                g = f + a(b).height(),
                h = e.offset().top,
                i = h + e.height(),
                j = this.options.threshold;
            return !(!d || "scroll" != d.type || !this.options.load_all_images_on_first_scroll) || i >= f - j && h <= g + j
        }, e.prototype._load_img = function(b) {
            var c = a(b),
                d = c.attr(this.options.attribute[0]),
                e = c.attr(this.options.attribute[1]),
                f = this;
            c.parent().addClass("smart-loading"), c.unbind("load_img").hide().removeAttr(this.options.attribute.join(" ")).attr("srcset", e).attr("src", d).load(function() {
                if (c.hasClass("tc-smart-loaded") || c.fadeIn(f.options.fadeIn_options).addClass("tc-smart-loaded"), "undefined" != typeof c.attr("data-tcjp-recalc-dims") && !1 !== c.attr("data-tcjp-recalc-dims")) {
                    var a = c.originalWidth();
                    if (_height = c.originalHeight(), 2 != _.size(_.filter([a, _height], function(a) {
                            return _.isNumber(parseInt(a, 10)) && a > 1
                        }))) return;
                    c.removeAttr("data-tcjp-recalc-dims scale"), c.attr("width", a), c.attr("height", _height)
                }
                c.trigger("smartload")
            }), c[0].complete && c.load(), c.parent().removeClass("smart-loading")
        }, a.fn[f] = function(b) {
            return this.each(function() {
                a.data(this, "plugin_" + f) || a.data(this, "plugin_" + f, new e(this, b))
            })
        }
    }(jQuery, window, document),
    function(a, b, c, d) {
        function e(b, c) {
            this.$_el = a(b), this.options = a.extend({}, g, c), this._href = a.trim(this.$_el.attr("href")), this.init()
        }
        var f = "extLinks",
            g = {
                addIcon: !0,
                iconClassName: "tc-external",
                newTab: !0,
                skipSelectors: {
                    classes: [],
                    ids: []
                },
                skipChildTags: ["IMG"]
            };
        e.prototype.init = function() {
            var a = this,
                b = this.$_el.next("." + a.options.iconClassName);
            return this._is_eligible() ? (this.options.addIcon && 0 === b.length && this.$_el.after('<span class="' + a.options.iconClassName + '">'), void(this.options.newTab && "_blank" != this.$_el.attr("target") && this.$_el.attr("target", "_blank"))) : void(b.length && b.remove())
        }, e.prototype._is_eligible = function() {
            var b = this;
            if (this._is_external(this._href) && this._is_first_child_tag_allowed() && 2 == ["ids", "classes"].filter(function(a) {
                    return b._is_selector_allowed(a)
                }).length) {
                var c = !0;
                return a.each(this.$_el.parents(), function() {
                    if ("underline" == a(this).css("textDecoration")) return c = !1, !1
                }), c
            }
        }, e.prototype._is_selector_allowed = function(b) {
            if (czrapp) return czrapp.isSelectorAllowed(this.$_el, this.options.skipSelectors, b);
            var c = "ids" == b ? "id" : "class",
                d = this.options.skipSelectors[b];
            if ("object" != typeof this.options.skipSelectors || !this.options.skipSelectors[b] || !a.isArray(this.options.skipSelectors[b]) || 0 === this.options.skipSelectors[b].length) return !0;
            if (this.$_el.parents(d.map(function(a) {
                    return "id" == c ? "#" + a : "." + a
                }).join(",")).length > 0) return !1;
            if (!this.$_el.attr(c)) return !0;
            var e = this.$_el.attr(c).split(" "),
                f = e.filter(function(b) {
                    return -1 != a.inArray(b, d)
                });
            return 0 === f.length
        }, e.prototype._is_first_child_tag_allowed = function() {
            if (0 === this.$_el.children().length) return !0;
            var b = this.$_el.children().first()[0].tagName,
                c = this.options.skipChildTags;
            return !a.isArray(c) || (c = c.map(function(a) {
                return a.toUpperCase()
            }), -1 == a.inArray(b, c))
        }, e.prototype._is_external = function(b) {
            var c = location.host.split(".").slice(-2).join("."),
                d = new RegExp(c);
            if (b = a.trim(b), "" !== b && "#" != b && this._isValidURL(b)) return !d.test(b)
        }, e.prototype._isValidURL = function(a) {
            var b = /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;
            return b.test(a)
        }, a.fn[f] = function(b) {
            return this.each(function() {
                a.data(this, "plugin_" + f) || a.data(this, "plugin_" + f, new e(this, b))
            })
        }
    }(jQuery, window, document),
    function(a, b, c, d) {
        function e(b, c) {
            this.container = b, this.options = a.extend({}, g, c), this._defaults = g, this._name = f, this.init()
        }
        var f = "centerImages",
            g = {
                enableCentering: !0,
                onresize: !0,
                oncustom: [],
                imgSel: "img",
                defaultCSSVal: {
                    width: "auto",
                    height: "auto"
                },
                leftAdjust: 0,
                zeroLeftAdjust: 0,
                topAdjust: 0,
                zeroTopAdjust: -2,
                enableGoldenRatio: !1,
                goldenRatioLimitHeightTo: 350,
                goldenRatioVal: 1.618,
                skipGoldenRatioClasses: ["no-gold-ratio"],
                disableGRUnder: 767,
                useImgAttr: !1
            };
        e.prototype.init = function() {
            var c = this;
            this._maybe_apply_golden_r();
            var d = a(this.options.imgSel, this.container);
            d.length && this.options.enableCentering ? this._parse_imgs(d) : a(b).bind("resize", {}, function(a) {
                c._maybe_apply_golden_r(a)
            })
        }, e.prototype._maybe_apply_golden_r = function(b) {
            if (this.options.enableGoldenRatio && this.options.goldenRatioVal && 0 !== this.options.goldenRatioVal && this._is_selector_allowed()) {
                if (!this._is_window_width_allowed()) return void a(this.container).attr("style", "");
                var c = Math.round(a(this.container).width() / this.options.goldenRatioVal);
                c = c > this.options.goldenRatioLimitHeightTo ? this.options.goldenRatioLimitHeightTo : c, a(this.container).css({
                    "line-height": c + "px",
                    height: c + "px"
                }).trigger("golden-ratio-applied")
            }
        }, e.prototype._is_window_width_allowed = function() {
            return a(b).width() > this.options.disableGRUnder - 15
        }, e.prototype._parse_imgs = function(b) {
            var c = this;
            b.each(function(b, d) {
                c._pre_img_cent(a(d)), c._bind_evt(a(d))
            })
        }, e.prototype._bind_evt = function(c) {
            var d = this,
                e = a.isArray(this.options.oncustom) ? this.options.oncustom : this.options.oncustom.split(" ");
            a(b).bind("resize", {}, function(a) {
                d._maybe_apply_golden_r(a)
            }), this.options.onresize && a(b).resize(function() {
                d._pre_img_cent(c)
            }), e.map(function(a) {
                c.bind(a, {}, function(a) {
                    d._pre_img_cent(c)
                })
            })
        }, e.prototype._pre_img_cent = function(a) {
            var b = this._get_current_state(a);
            this._maybe_center_img(a, b)
        }, e.prototype._get_current_state = function(b) {
            var c = b.closest(this.container).outerWidth(),
                d = a(this.container).outerHeight(),
                e = this._get_img_dim(b, "x"),
                f = this._get_img_dim(b, "y"),
                g = f * d !== 0 ? Math.round(e / f * d) : c,
                h = e * c !== 0 ? Math.round(f / e * c) : d,
                i = "h";
            0 !== c * e && (i = d / c >= f / e ? "h" : "v");
            var j = {
                h: {
                    dim: {
                        name: "height",
                        val: d
                    },
                    dir: {
                        name: "left",
                        val: (c - g) / 2 + (this.options.leftAdjust || 0)
                    },
                    _class: "h-centered"
                },
                v: {
                    dim: {
                        name: "width",
                        val: c
                    },
                    dir: {
                        name: "top",
                        val: (d - h) / 2 + (this.options.topAdjust || 0)
                    },
                    _class: "v-centered"
                }
            };
            return {
                current: i,
                prop: j
            }
        }, e.prototype._get_img_dim = function(a, b) {
            if (!this.options.useImgAttr) return "x" == b ? a.outerWidth() : a.outerHeight();
            if (a.is(":visible")) return "x" == b ? a.outerWidth() : a.outerHeight();
            if ("x" == b) {
                var c = a.originalWidth();
                return typeof c === d ? 0 : c
            }
            if ("y" == b) {
                var e = a.originalHeight();
                return typeof e === d ? 0 : e
            }
        }, e.prototype._maybe_center_img = function(a, b) {
            var c = b.current,
                d = b.prop[c],
                e = b.prop["h" == c ? "v" : "h"],
                f = "h" == c ? this.options.zeroTopAdjust || 0 : this.options.zeroLeftAdjust || 0;
            a.css(d.dim.name, d.dim.val).css(e.dim.name, this.options.defaultCSSVal[e.dim.name] || "auto").addClass(d._class).removeClass(e._class).css(d.dir.name, d.dir.val).css(e.dir.name, f)
        }, e.prototype._is_selector_allowed = function() {
            if (!a(this.container).attr("class")) return !0;
            if (!this.options.skipGoldenRatioClasses || !a.isArray(this.options.skipGoldenRatioClasses)) return !0;
            var b = a(this.container).attr("class").split(" "),
                c = this.options.skipGoldenRatioClasses,
                d = b.filter(function(b) {
                    return -1 != a.inArray(b, c)
                });
            return 0 === d.length
        }, a.fn[f] = function(b) {
            return this.each(function() {
                a.data(this, "plugin_" + f) || a.data(this, "plugin_" + f, new e(this, b))
            })
        }
    }(jQuery, window, document),
    function(a, b, c, d) {
        function e(b, c) {
            this.element = a(b), this.options = a.extend({}, g, c, this.parseElementDataOptions()), this._defaults = g, this._name = f, this.init()
        }
        var f = "czrParallax",
            g = {
                parallaxRatio: .5,
                parallaxDirection: 1,
                parallaxOverflowHidden: !0,
                oncustom: [],
                backgroundClass: "image"
            };
        e.prototype.parseElementDataOptions = function() {
            return this.element.data()
        }, e.prototype.init = function() {
            this.$_document = a(c), this.$_window = czrapp ? czrapp.$_window : a(b), this.initWaypoints(), this.stageParallaxElements(), this._bind_evt()
        }, e.prototype._bind_evt = function() {
            a.isArray(this.options.oncustom) ? this.options.oncustom : this.options.oncustom.split(" ");
            _.bindAll(this, "parallaxMe")
        }, e.prototype.stageParallaxElements = function() {
            if (this.element.css("position", this.element.hasClass(this.options.backgroundClass) ? "absolute" : "relative"), this.options.parallaxOverflowHidden) {
                var a = this.element.closest(".parallax-wrapper");
                a.length && a.css("overflow", "hidden")
            }
        }, e.prototype.initWaypoints = function() {
            var a = this;
            this.way_start = new Waypoint({
                element: a.element,
                handler: function() {
                    a.element.hasClass("parallaxing") ? (a.element.removeClass("parallaxing"), a.$_window.off("scroll", a.parallaxMe), a.element.css("top", 0)) : (a.$_window.on("scroll", a.parallaxMe), a.element.addClass("parallaxing"))
                }
            }), this.way_stop = new Waypoint({
                element: a.element,
                handler: function() {
                    a.element.hasClass("parallaxing") ? (a.element.removeClass("parallaxing"), a.$_window.off("scroll", a.parallaxMe)) : (a.$_window.on("scroll", a.parallaxMe), a.element.addClass("parallaxing"))
                },
                offset: function() {
                    return offset = this.context.innerHeight() - this.adapter.outerHeight(), -(offset > 20 ? offset : this.context.innerHeight())
                }
            })
        }, e.prototype.parallaxMe = function() {
            var a = this.options.parallaxRatio,
                b = this.options.parallaxDirection,
                c = a * b * (this.$_document.scrollTop() - this.way_start.triggerPoint);
            this.element.css("top", b * c < 0 ? 0 : c)
        }, a.fn[f] = function(b) {
            return this.each(function() {
                a.data(this, "plugin_" + f) || a.data(this, "plugin_" + f, new e(this, b))
            })
        }
    }(jQuery, window, document),
    function() {
        function a() {
            D.keyboardSupport && n("keydown", f)
        }

        function b() {
            if (!H && document.body) {
                H = !0;
                var b = document.body,
                    c = document.documentElement,
                    d = window.innerHeight,
                    e = b.scrollHeight;
                if (I = document.compatMode.indexOf("CSS") >= 0 ? c : b, y = b, a(), top != self) F = !0;
                else if (e > d && (b.offsetHeight <= d || c.offsetHeight <= d)) {
                    var f = document.createElement("div");
                    f.style.cssText = "position:absolute; z-index:-10000; top:0; left:0; right:0; height:" + I.scrollHeight + "px", document.body.appendChild(f);
                    var g, h = function() {
                        g || (g = setTimeout(function() {
                            E || (f.style.height = "0", f.style.height = I.scrollHeight + "px", g = null)
                        }, 500))
                    };
                    setTimeout(h, 10);
                    var i = {
                        attributes: !0,
                        childList: !0,
                        characterData: !1
                    };
                    if (z = new T(h), z.observe(b, i), I.offsetHeight <= d) {
                        var j = document.createElement("div");
                        j.style.clear = "both", b.appendChild(j)
                    }
                }
                D.fixedBackground || E || (b.style.backgroundAttachment = "scroll", c.style.backgroundAttachment = "scroll")
            }
        }

        function c() {
            z && z.disconnect(), o(R, e), o("mousedown", g), o("keydown", f)
        }

        function d(a, b, c) {
            if (q(b, c), 1 != D.accelerationMax) {
                var d = Date.now(),
                    e = d - O;
                if (e < D.accelerationDelta) {
                    var f = (1 + 50 / e) / 2;
                    f > 1 && (f = Math.min(f, D.accelerationMax), b *= f, c *= f)
                }
                O = Date.now()
            }
            if (M.push({
                    x: b,
                    y: c,
                    lastX: b < 0 ? .99 : -.99,
                    lastY: c < 0 ? .99 : -.99,
                    start: Date.now()
                }), !N) {
                var g = a === document.body,
                    h = function(d) {
                        for (var e = Date.now(), f = 0, i = 0, j = 0; j < M.length; j++) {
                            var k = M[j],
                                l = e - k.start,
                                m = l >= D.animationTime,
                                n = m ? 1 : l / D.animationTime;
                            D.pulseAlgorithm && (n = w(n));
                            var o = k.x * n - k.lastX >> 0,
                                p = k.y * n - k.lastY >> 0;
                            f += o, i += p, k.lastX += o, k.lastY += p, m && (M.splice(j, 1), j--)
                        }
                        g ? window.scrollBy(f, i) : (f && (a.scrollLeft += f), i && (a.scrollTop += i)), b || c || (M = []), M.length ? S(h, a, 1e3 / D.frameRate + 1) : N = !1
                    };
                S(h, a, 0), N = !0
            }
        }

        function e(a) {
            H || b();
            var c = a.target,
                e = j(c);
            if (!e || a.defaultPrevented || a.ctrlKey) return !0;
            if (p(y, "embed") || p(c, "embed") && /\.pdf/i.test(c.src) || p(y, "object")) return !0;
            var f = -a.wheelDeltaX || a.deltaX || 0,
                g = -a.wheelDeltaY || a.deltaY || 0;
            return K && (a.wheelDeltaX && s(a.wheelDeltaX, 120) && (f = -120 * (a.wheelDeltaX / Math.abs(a.wheelDeltaX))), a.wheelDeltaY && s(a.wheelDeltaY, 120) && (g = -120 * (a.wheelDeltaY / Math.abs(a.wheelDeltaY)))), f || g || (g = -a.wheelDelta || 0), 1 === a.deltaMode && (f *= 40, g *= 40), !(D.touchpadSupport || !r(g)) || (Math.abs(f) > 1.2 && (f *= D.stepSize / 120), Math.abs(g) > 1.2 && (g *= D.stepSize / 120), d(e, f, g), a.preventDefault(), void h())
        }

        function f(a) {
            var b = a.target,
                c = a.ctrlKey || a.altKey || a.metaKey || a.shiftKey && a.keyCode !== L.spacebar;
            document.contains(y) || (y = document.activeElement);
            var e = /^(textarea|select|embed|object)$/i,
                f = /^(button|submit|radio|checkbox|file|color|image)$/i;
            if (e.test(b.nodeName) || p(b, "input") && !f.test(b.type) || p(y, "video") || u(a) || b.isContentEditable || a.defaultPrevented || c) return !0;
            if ((p(b, "button") || p(b, "input") && f.test(b.type)) && a.keyCode === L.spacebar) return !0;
            var g, i = 0,
                k = 0,
                l = j(y),
                m = l.clientHeight;
            switch (l == document.body && (m = window.innerHeight), a.keyCode) {
                case L.up:
                    k = -D.arrowScroll;
                    break;
                case L.down:
                    k = D.arrowScroll;
                    break;
                case L.spacebar:
                    g = a.shiftKey ? 1 : -1, k = -g * m * .9;
                    break;
                case L.pageup:
                    k = .9 * -m;
                    break;
                case L.pagedown:
                    k = .9 * m;
                    break;
                case L.home:
                    k = -l.scrollTop;
                    break;
                case L.end:
                    var n = l.scrollHeight - l.scrollTop - m;
                    k = n > 0 ? n + 10 : 0;
                    break;
                case L.left:
                    i = -D.arrowScroll;
                    break;
                case L.right:
                    i = D.arrowScroll;
                    break;
                default:
                    return !0
            }
            d(l, i, k), a.preventDefault(), h()
        }

        function g(a) {
            y = a.target
        }

        function h() {
            clearTimeout(A), A = setInterval(function() {
                Q = {}
            }, 1e3)
        }

        function i(a, b) {
            for (var c = a.length; c--;) Q[P(a[c])] = b;
            return b
        }

        function j(a) {
            var b = [],
                c = document.body,
                d = I.scrollHeight;
            do {
                var e = Q[P(a)];
                if (e) return i(b, e);
                if (b.push(a), d === a.scrollHeight) {
                    var f = l(I) && l(c),
                        g = f || m(I);
                    if (F && k(I) || !F && g) return i(b, U())
                } else if (k(a) && m(a)) return i(b, a)
            } while (a = a.parentElement)
        }

        function k(a) {
            return a.clientHeight + 10 < a.scrollHeight
        }

        function l(a) {
            var b = getComputedStyle(a, "").getPropertyValue("overflow-y");
            return "hidden" !== b
        }

        function m(a) {
            var b = getComputedStyle(a, "").getPropertyValue("overflow-y");
            return "scroll" === b || "auto" === b
        }

        function n(a, b) {
            window.addEventListener(a, b, !1)
        }

        function o(a, b) {
            window.removeEventListener(a, b, !1)
        }

        function p(a, b) {
            return (a.nodeName || "").toLowerCase() === b.toLowerCase()
        }

        function q(a, b) {
            a = a > 0 ? 1 : -1, b = b > 0 ? 1 : -1, G.x === a && G.y === b || (G.x = a, G.y = b, M = [], O = 0)
        }

        function r(a) {
            if (a) return J.length || (J = [a, a, a]), a = Math.abs(a), J.push(a), J.shift(), clearTimeout(B), B = setTimeout(function() {
                window.localStorage && (localStorage.SS_deltaBuffer = J.join(","))
            }, 1e3), !t(120) && !t(100)
        }

        function s(a, b) {
            return Math.floor(a / b) == a / b
        }

        function t(a) {
            return s(J[0], a) && s(J[1], a) && s(J[2], a)
        }

        function u(a) {
            var b = a.target,
                c = !1;
            if (document.URL.indexOf("www.youtube.com/watch") != -1)
                do
                    if (c = b.classList && b.classList.contains("html5-video-controls")) break; while (b = b.parentNode);
            return c
        }

        function v(a) {
            var b, c, d;
            return a *= D.pulseScale, a < 1 ? b = a - (1 - Math.exp(-a)) : (c = Math.exp(-1), a -= 1, d = 1 - Math.exp(-a), b = c + d * (1 - c)), b * D.pulseNormalize
        }

        function w(a) {
            return a >= 1 ? 1 : a <= 0 ? 0 : (1 == D.pulseNormalize && (D.pulseNormalize /= v(1)), v(a))
        }

        function x(a) {
            return R && (n(R, e), n("mousedown", g), a ? b() : n("load", b)), !!R
        }
        var y, z, A, B, C = {
                frameRate: 150,
                animationTime: 400,
                stepSize: 120,
                pulseAlgorithm: !0,
                pulseScale: 4,
                pulseNormalize: 1,
                accelerationDelta: 20,
                accelerationMax: 1,
                keyboardSupport: !0,
                arrowScroll: 50,
                touchpadSupport: !0,
                fixedBackground: !0,
                excluded: ""
            },
            D = C,
            E = !1,
            F = !1,
            G = {
                x: 0,
                y: 0
            },
            H = !1,
            I = document.documentElement,
            J = [],
            K = /^Mac/.test(navigator.platform),
            L = {
                left: 37,
                up: 38,
                right: 39,
                down: 40,
                spacebar: 32,
                pageup: 33,
                pagedown: 34,
                end: 35,
                home: 36
            },
            D = C,
            M = [],
            N = !1,
            O = Date.now(),
            P = function() {
                var a = 0;
                return function(b) {
                    return b.uniqueID || (b.uniqueID = a++)
                }
            }(),
            Q = {};
        window.localStorage && localStorage.SS_deltaBuffer && (J = localStorage.SS_deltaBuffer.split(","));
        var R, S = function() {
                return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || function(a, b, c) {
                    window.setTimeout(a, c || 1e3 / 60)
                }
            }(),
            T = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver,
            U = function() {
                var a;
                return function() {
                    if (!a) {
                        var b = document.createElement("div");
                        b.style.cssText = "height:10000px;width:1px;", document.body.appendChild(b);
                        var c = document.body.scrollTop;
                        document.documentElement.scrollTop;
                        window.scrollBy(0, 1), a = document.body.scrollTop != c ? document.body : document.documentElement, window.scrollBy(0, -1), document.body.removeChild(b)
                    }
                    return a
                }
            }();
        "onwheel" in document.createElement("div") ? R = "wheel" : "onmousewheel" in document.createElement("div") && (R = "mousewheel"), smoothScroll = function(a) {
            smoothScroll._setCustomOptions(a), x(), czrapp.$_body.addClass("hu-smoothscroll")
        }, smoothScroll._cleanUp = function() {
            c(), czrapp.$_body.removeClass("hu-smoothscroll")
        }, smoothScroll._maybeFire = function() {
            x(!0), czrapp.$_body.addClass("hu-smoothscroll")
        }, smoothScroll._setCustomOptions = function(a) {
            D = a ? _.extend(D, a) : D
        }
    }();
var smoothScroll, tcOutline;
! function(a) {
    tcOutline = function() {
        var b = a.createElement("STYLE"),
            c = "addEventListener" in a,
            d = function(b, d) {
                c ? a.addEventListener(b, d) : a.attachEvent("on" + b, d)
            },
            e = function(a) {
                b.styleSheet ? b.styleSheet.cssText = a : b.innerHTML = a
            };
        a.getElementsByTagName("HEAD")[0].appendChild(b), d("mousedown", function() {
            e("input[type=file]:focus,input[type=radio]:focus,input[type=checkbox]:focus,select:focus,a:focus{outline:0}input[type=file]::-moz-focus-inner,input[type=radio]::-moz-focus-inner,input[type=checkbox]::-moz-focus-inner,select::-moz-focus-inner,a::-moz-focus-inner{border:0;}")
        }), d("keydown", function() {
            e("")
        })
    }
}(document),
/*!
Waypoints - 4.0.0
Copyright © 2011-2015 Caleb Troughton
Licensed under the MIT license.
https://github.com/imakewebthings/waypoints/blob/master/licenses.txt
*/
function() {
    "use strict";

    function a(d) {
        if (!d) throw new Error("No options passed to Waypoint constructor");
        if (!d.element) throw new Error("No element option passed to Waypoint constructor");
        if (!d.handler) throw new Error("No handler option passed to Waypoint constructor");
        this.key = "waypoint-" + b, this.options = a.Adapter.extend({}, a.defaults, d), this.element = this.options.element, this.adapter = new a.Adapter(this.element), this.callback = d.handler, this.axis = this.options.horizontal ? "horizontal" : "vertical", this.enabled = this.options.enabled, this.triggerPoint = null, this.group = a.Group.findOrCreate({
            name: this.options.group,
            axis: this.axis
        }), this.context = a.Context.findOrCreateByElement(this.options.context), a.offsetAliases[this.options.offset] && (this.options.offset = a.offsetAliases[this.options.offset]), this.group.add(this), this.context.add(this), c[this.key] = this, b += 1
    }
    var b = 0,
        c = {};
    a.prototype.queueTrigger = function(a) {
        this.group.queueTrigger(this, a)
    }, a.prototype.trigger = function(a) {
        this.enabled && this.callback && this.callback.apply(this, a)
    }, a.prototype.destroy = function() {
        this.context.remove(this), this.group.remove(this), delete c[this.key]
    }, a.prototype.disable = function() {
        return this.enabled = !1, this
    }, a.prototype.enable = function() {
        return this.context.refresh(), this.enabled = !0, this
    }, a.prototype.next = function() {
        return this.group.next(this)
    }, a.prototype.previous = function() {
        return this.group.previous(this)
    }, a.invokeAll = function(a) {
        var b = [];
        for (var d in c) b.push(c[d]);
        for (var e = 0, f = b.length; e < f; e++) b[e][a]()
    }, a.destroyAll = function() {
        a.invokeAll("destroy")
    }, a.disableAll = function() {
        a.invokeAll("disable")
    }, a.enableAll = function() {
        a.invokeAll("enable")
    }, a.refreshAll = function() {
        a.Context.refreshAll()
    }, a.viewportHeight = function() {
        return window.innerHeight || document.documentElement.clientHeight
    }, a.viewportWidth = function() {
        return document.documentElement.clientWidth
    }, a.adapters = [], a.defaults = {
        context: window,
        continuous: !0,
        enabled: !0,
        group: "default",
        horizontal: !1,
        offset: 0
    }, a.offsetAliases = {
        "bottom-in-view": function() {
            return this.context.innerHeight() - this.adapter.outerHeight()
        },
        "right-in-view": function() {
            return this.context.innerWidth() - this.adapter.outerWidth()
        }
    }, window.Waypoint = a
}(),
function() {
    "use strict";

    function a(a) {
        window.setTimeout(a, 1e3 / 60)
    }

    function b(a) {
        this.element = a, this.Adapter = e.Adapter, this.adapter = new this.Adapter(a), this.key = "waypoint-context-" + c, this.didScroll = !1, this.didResize = !1, this.oldScroll = {
            x: this.adapter.scrollLeft(),
            y: this.adapter.scrollTop()
        }, this.waypoints = {
            vertical: {},
            horizontal: {}
        }, a.waypointContextKey = this.key, d[a.waypointContextKey] = this, c += 1, this.createThrottledScrollHandler(), this.createThrottledResizeHandler()
    }
    var c = 0,
        d = {},
        e = window.Waypoint,
        f = window.onload;
    b.prototype.add = function(a) {
        var b = a.options.horizontal ? "horizontal" : "vertical";
        this.waypoints[b][a.key] = a, this.refresh()
    }, b.prototype.checkEmpty = function() {
        var a = this.Adapter.isEmptyObject(this.waypoints.horizontal),
            b = this.Adapter.isEmptyObject(this.waypoints.vertical);
        a && b && (this.adapter.off(".waypoints"), delete d[this.key])
    }, b.prototype.createThrottledResizeHandler = function() {
        function a() {
            b.handleResize(), b.didResize = !1
        }
        var b = this;
        this.adapter.on("resize.waypoints", function() {
            b.didResize || (b.didResize = !0, e.requestAnimationFrame(a))
        })
    }, b.prototype.createThrottledScrollHandler = function() {
        function a() {
            b.handleScroll(), b.didScroll = !1
        }
        var b = this;
        this.adapter.on("scroll.waypoints", function() {
            b.didScroll && !e.isTouch || (b.didScroll = !0, e.requestAnimationFrame(a))
        })
    }, b.prototype.handleResize = function() {
        e.Context.refreshAll()
    }, b.prototype.handleScroll = function() {
        var a = {},
            b = {
                horizontal: {
                    newScroll: this.adapter.scrollLeft(),
                    oldScroll: this.oldScroll.x,
                    forward: "right",
                    backward: "left"
                },
                vertical: {
                    newScroll: this.adapter.scrollTop(),
                    oldScroll: this.oldScroll.y,
                    forward: "down",
                    backward: "up"
                }
            };
        for (var c in b) {
            var d = b[c],
                e = d.newScroll > d.oldScroll,
                f = e ? d.forward : d.backward;
            for (var g in this.waypoints[c]) {
                var h = this.waypoints[c][g],
                    i = d.oldScroll < h.triggerPoint,
                    j = d.newScroll >= h.triggerPoint,
                    k = i && j,
                    l = !i && !j;
                (k || l) && (h.queueTrigger(f), a[h.group.id] = h.group)
            }
        }
        for (var m in a) a[m].flushTriggers();
        this.oldScroll = {
            x: b.horizontal.newScroll,
            y: b.vertical.newScroll
        }
    }, b.prototype.innerHeight = function() {
        return this.element == this.element.window ? e.viewportHeight() : this.adapter.innerHeight()
    }, b.prototype.remove = function(a) {
        delete this.waypoints[a.axis][a.key], this.checkEmpty()
    }, b.prototype.innerWidth = function() {
        return this.element == this.element.window ? e.viewportWidth() : this.adapter.innerWidth()
    }, b.prototype.destroy = function() {
        var a = [];
        for (var b in this.waypoints)
            for (var c in this.waypoints[b]) a.push(this.waypoints[b][c]);
        for (var d = 0, e = a.length; d < e; d++) a[d].destroy()
    }, b.prototype.refresh = function() {
        var a, b = this.element == this.element.window,
            c = b ? void 0 : this.adapter.offset(),
            d = {};
        this.handleScroll(), a = {
            horizontal: {
                contextOffset: b ? 0 : c.left,
                contextScroll: b ? 0 : this.oldScroll.x,
                contextDimension: this.innerWidth(),
                oldScroll: this.oldScroll.x,
                forward: "right",
                backward: "left",
                offsetProp: "left"
            },
            vertical: {
                contextOffset: b ? 0 : c.top,
                contextScroll: b ? 0 : this.oldScroll.y,
                contextDimension: this.innerHeight(),
                oldScroll: this.oldScroll.y,
                forward: "down",
                backward: "up",
                offsetProp: "top"
            }
        };
        for (var f in a) {
            var g = a[f];
            for (var h in this.waypoints[f]) {
                var i, j, k, l, m, n = this.waypoints[f][h],
                    o = n.options.offset,
                    p = n.triggerPoint,
                    q = 0,
                    r = null == p;
                n.element !== n.element.window && (q = n.adapter.offset()[g.offsetProp]), "function" == typeof o ? o = o.apply(n) : "string" == typeof o && (o = parseFloat(o), n.options.offset.indexOf("%") > -1 && (o = Math.ceil(g.contextDimension * o / 100))), i = g.contextScroll - g.contextOffset, n.triggerPoint = q + i - o, j = p < g.oldScroll, k = n.triggerPoint >= g.oldScroll, l = j && k, m = !j && !k, !r && l ? (n.queueTrigger(g.backward), d[n.group.id] = n.group) : !r && m ? (n.queueTrigger(g.forward), d[n.group.id] = n.group) : r && g.oldScroll >= n.triggerPoint && (n.queueTrigger(g.forward), d[n.group.id] = n.group)
            }
        }
        return e.requestAnimationFrame(function() {
            for (var a in d) d[a].flushTriggers()
        }), this
    }, b.findOrCreateByElement = function(a) {
        return b.findByElement(a) || new b(a)
    }, b.refreshAll = function() {
        for (var a in d) d[a].refresh()
    }, b.findByElement = function(a) {
        return d[a.waypointContextKey]
    }, window.onload = function() {
        f && f(), b.refreshAll()
    }, e.requestAnimationFrame = function(b) {
        var c = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || a;
        c.call(window, b)
    }, e.Context = b
}(),
function() {
    "use strict";

    function a(a, b) {
        return a.triggerPoint - b.triggerPoint
    }

    function b(a, b) {
        return b.triggerPoint - a.triggerPoint
    }

    function c(a) {
        this.name = a.name, this.axis = a.axis, this.id = this.name + "-" + this.axis, this.waypoints = [], this.clearTriggerQueues(), d[this.axis][this.name] = this
    }
    var d = {
            vertical: {},
            horizontal: {}
        },
        e = window.Waypoint;
    c.prototype.add = function(a) {
        this.waypoints.push(a)
    }, c.prototype.clearTriggerQueues = function() {
        this.triggerQueues = {
            up: [],
            down: [],
            left: [],
            right: []
        }
    }, c.prototype.flushTriggers = function() {
        for (var c in this.triggerQueues) {
            var d = this.triggerQueues[c],
                e = "up" === c || "left" === c;
            d.sort(e ? b : a);
            for (var f = 0, g = d.length; f < g; f += 1) {
                var h = d[f];
                (h.options.continuous || f === d.length - 1) && h.trigger([c])
            }
        }
        this.clearTriggerQueues()
    }, c.prototype.next = function(b) {
        this.waypoints.sort(a);
        var c = e.Adapter.inArray(b, this.waypoints),
            d = c === this.waypoints.length - 1;
        return d ? null : this.waypoints[c + 1]
    }, c.prototype.previous = function(b) {
        this.waypoints.sort(a);
        var c = e.Adapter.inArray(b, this.waypoints);
        return c ? this.waypoints[c - 1] : null
    }, c.prototype.queueTrigger = function(a, b) {
        this.triggerQueues[b].push(a)
    }, c.prototype.remove = function(a) {
        var b = e.Adapter.inArray(a, this.waypoints);
        b > -1 && this.waypoints.splice(b, 1)
    }, c.prototype.first = function() {
        return this.waypoints[0]
    }, c.prototype.last = function() {
        return this.waypoints[this.waypoints.length - 1]
    }, c.findOrCreate = function(a) {
        return d[a.axis][a.name] || new c(a)
    }, e.Group = c
}(),
function() {
    "use strict";

    function a(a) {
        this.$element = b(a)
    }
    var b = window.jQuery,
        c = window.Waypoint;
    b.each(["innerHeight", "innerWidth", "off", "offset", "on", "outerHeight", "outerWidth", "scrollLeft", "scrollTop"], function(b, c) {
        a.prototype[c] = function() {
            var a = Array.prototype.slice.call(arguments);
            return this.$element[c].apply(this.$element, a)
        }
    }), b.each(["extend", "inArray", "isEmptyObject"], function(c, d) {
        a[d] = b[d]
    }), c.adapters.push({
        name: "jquery",
        Adapter: a
    }), c.Adapter = a
}(),
function() {
    "use strict";

    function a(a) {
        return function() {
            var c = [],
                d = arguments[0];
            return a.isFunction(arguments[0]) && (d = a.extend({}, arguments[1]), d.handler = arguments[0]), this.each(function() {
                var e = a.extend({}, d, {
                    element: this
                });
                "string" == typeof e.context && (e.context = a(this).closest(e.context)[0]), c.push(new b(e))
            }), c
        }
    }
    var b = window.Waypoint;
    window.jQuery && (window.jQuery.fn.waypoint = a(window.jQuery)), window.Zepto && (window.Zepto.fn.waypoint = a(window.Zepto))
}();
var czrapp = czrapp || {};
! function(a, b) {
    var c = Array.prototype.slice;
    a.extend(b, {
        instances: {},
        methods: {},
        Base: function() {},
        _inherits: function(a) {
            return b[a] = function() {
                b.Base.call(this)
            }, b[a].prototype = Object.create(b.Base.prototype), b[a].prototype.constructor = b[a], b
        },
        _instanciates: function(a) {
            return b.instances[a] = b.instances[a] || new b[a], b
        },
        _init: function(a, c) {
            var d = b.instances[a] || !1;
            if (d) return d.init && d.init(), d.emit(c), b
        },
        _addMethods: function(c) {
            return a.extend(b[c].prototype, b._getMethods(c)), b
        },
        _getMethods: function(a) {
            return b.methods[a] || {}
        },
        cacheProp: function() {
            return a.extend(b, {
                $_window: a(window),
                $_html: a("html"),
                $_body: a("body"),
                $_tcHeader: a(".tc-header"),
                $_wpadminbar: a("#wpadminbar"),
                localized: HUParams || {},
                is_responsive: this.isResponsive(),
                current_device: this.getDevice()
            }), b
        },
        emitCustomEvents: function() {
            var a = this;
            return b.$_window.resize(function(c) {
                var d = (b.$_window.width(), b.current_device),
                    e = a.getDevice();
                b.is_responsive = a.isResponsive(), b.current_device = e, b.$_body.trigger("tc-resize", {
                    current: d,
                    to: e
                })
            }), b
        },
        isResponsive: function() {
            return a(window).width() <= 964
        },
        getDevice: function() {
            var c = {
                    desktop: 964,
                    tablet: 752,
                    smartphone: 465
                },
                d = "desktop",
                e = b.$_window || a(window);
            return _.map(c, function(a, b) {
                e.width() <= a && (d = b)
            }), d
        },
        isSelectorAllowed: function(b, c, d) {
            var e = "ids" == d ? "id" : "class",
                f = c[d];
            if ("object" != typeof c || !c[d] || !a.isArray(c[d]) || 0 === c[d].length) return !0;
            if (b.parents(f.map(function(a) {
                    return "id" == e ? "#" + a : "." + a
                }).join(",")).length > 0) return !1;
            if (!b.attr(e)) return !0;
            var g = b.attr(e).split(" "),
                h = g.filter(function(b) {
                    return -1 != a.inArray(b, f)
                });
            return 0 === h.length
        },
        trigger: function(a) {
            return this.topics && this.topics[a] && this.topics[a].fireWith(this, c.call(arguments, 1)), this
        },
        bind: function(b) {
            return this.topics = this.topics || {}, this.topics[b] = this.topics[b] || a.Callbacks(), this.topics[b].add.apply(this.topics[b], c.call(arguments, 1)), this
        },
        unbind: function(a) {
            return this.topics && this.topics[a] && this.topics[a].remove.apply(this.topics[a], c.call(arguments, 1)), this
        },
        loadCzr: function(a) {
            var c = this;
            c.localized._disabled || {};
            _.each(a, function(a, d) {
                if (a = "string" == typeof a ? [a] : a, !c.localized._disabled[d] || !_.isEmpty(c.localized._disabled[d])) {
                    if (c.localized._disabled[d] && !_.isEmpty(c.localized._disabled[d])) {
                        var e = c.localized._disabled[d];
                        e = "string" == typeof e ? [e] : e, a = _.difference(a, e)
                    }
                    b._inherits(d)._instanciates(d)._addMethods(d)._init(d, a)
                }
            }), b.trigger("czrapp-ready", this)
        }
    })
}(jQuery, czrapp),
function(a, b) {
    var c = {
        emit: function(a, c) {
            a = _.isArray(a) ? a : [a];
            var d = this;
            _.map(a, function(a) {
                "function" == typeof d[a] && (c = "undefined" == typeof c ? Array() : c, d[a].apply(d, c), b.trigger(a, _.object(_.keys(c), c)))
            })
        },
        triggerSimpleLoad: function(b) {
            0 !== b.length && b.map(function(b, c) {
                a(c).load(function() {
                    a(c).trigger("simple_load")
                }), a(c)[0] && a(c)[0].complete && a(c).load()
            })
        },
        isUserLogged: function() {
            return b.$_body.hasClass("logged-in") || 0 !== b.$_wpadminbar.length
        },
        isCustomizing: function() {
            return b.$_body.hasClass("is-customizing")
        },
        getDevice: function() {
            return b.getDevice()
        },
        isReponsive: function() {
            return b.isReponsive()
        },
        isSelectorAllowed: function(a, c, d) {
            return b.isSelectorAllowed(a, c, d)
        }
    };
    a.extend(b.Base.prototype, c)
}(jQuery, czrapp),
function(a, b) {
    var c = {
        init: function() {
            a.browser.chrome ? b.$_body.addClass("chrome") : a.browser.webkit && b.$_body.addClass("safari"), a.browser.mozilla ? b.$_body.addClass("mozilla") : (a.browser.msie || "8.0" === a.browser.version || "9.0" === a.browser.version || "10.0" === a.browser.version || "11.0" === a.browser.version) && b.$_body.addClass("ie").addClass("ie" + a.browser.version.replace(/[.0]/g, "")), b.$_body.hasClass("ie") && b.$_body.addClass(a.browser.version)
        }
    };
    a.extend(b.methods.BrowserDetect = {}, c)
}(jQuery, czrapp);
var czrapp = czrapp || {};
! function(a, b) {
    var c = {
        imgSmartLoad: function() {
            var b = 1 == HUParams.imgSmartLoadEnabled,
                c = HUParams.imgSmartLoadOpts.parentSelectors.join();
            if (b && a(c).imgSmartLoad(_.size(HUParams.imgSmartLoadOpts.opts) > 0 ? HUParams.imgSmartLoadOpts.opts : {}), 1 == HUParams.centerAllImg) {
                var d = this,
                    e = b ? a(_.filter(a(c).find("img"), function(b) {
                        return a(b).is(HUParams.imgSmartLoadOpts.opts.excludeImg.join())
                    })) : a(c).find("img");
                $_to_center_with_delay = a(_.filter(e, function(b) {
                    return a(b).hasClass("tc-holder-img")
                })), setTimeout(function() {
                    d.triggerSimpleLoad($_to_center_with_delay)
                }, 300), d.triggerSimpleLoad(e)
            }
        },
        extLinks: function() {
            (HUParams.extLinksStyle || HUParams.extLinksTargetExt) && a("a", ".post-inner .entry").extLinks({
                addIcon: HUParams.extLinksStyle,
                iconClassName: "hu-external",
                newTab: HUParams.extLinksTargetExt,
                skipSelectors: _.isObject(HUParams.extLinksSkipSelectors) ? HUParams.extLinksSkipSelectors : {}
            })
        },
        parallax: function() {
            a(".parallax-item").czrParallax()
        }
    };
    a.extend(b.methods.Czr_Plugins = {}, c)
}(jQuery, czrapp);
var czrapp = czrapp || {};
! function(a, b) {
    var c = {
        init: function() {
            this.timer = 0, this.increment = 1
        },
        outline: function() {
            b.$_body.hasClass("mozilla") && "function" == typeof tcOutline && tcOutline()
        },
        smoothScroll: function() {
            HUParams.SmoothScroll && HUParams.SmoothScroll.Enabled && smoothScroll(HUParams.SmoothScroll.Options)
        },
        toggleHeaderSearch: function() {
            a(".toggle-search").click(function() {
                a(".toggle-search").toggleClass("active"), a(".search-expand").fadeToggle(250), setTimeout(function() {
                    a(".search-expand input").focus()
                }, 300)
            })
        },
        scrollToTop: function() {
            a("a#back-to-top").click(function() {
                return a("html, body").animate({
                    scrollTop: 0
                }, "slow"), !1
            })
        },
        widgetTabs: function() {
            var b = a(".alx-tabs-nav"),
                c = b.children("li");
            a(".alx-tabs-container");
            b.each(function() {
                var b = a(this);
                b.next().children(".alx-tab").stop(!0, !0).hide().siblings(b.find("a").attr("href")).show(), b.children("li").first().addClass("active").stop(!0, !0).show()
            }), c.on("click", function(b) {
                var c = a(this);
                c.siblings().removeClass("active").end().addClass("active"), c.parent().next().children(".alx-tab").stop(!0, !0).hide().siblings(c.find("a").attr("href")).fadeIn(), b.preventDefault()
            }).children(window.location.hash ? 'a[href="' + window.location.hash + '"]' : "a:first").trigger("click")
        },
        commentTabs: function() {
            a(".comment-tabs li").click(function() {
                a(".comment-tabs li").removeClass("active"), a(this).addClass("active"), a(".comment-tab").hide();
                var b = a(this).find("a").attr("href");
                return a(b).fadeIn(), !1
            })
        },
        tableStyle: function() {
            a("table tr:odd").addClass("alt")
        },
        sidebarCollapse: function() {
            a("body").addClass("s1-collapse"), a("body").addClass("s2-collapse"), a(".s1 .sidebar-toggle").click(function() {
                a("body").toggleClass("s1-collapse").toggleClass("s1-expand"), a("body").is(".s2-expand") && a("body").toggleClass("s2-expand").toggleClass("s2-collapse")
            }), a(".s2 .sidebar-toggle").click(function() {
                a("body").toggleClass("s2-collapse").toggleClass("s2-expand"), a("body").is(".s1-expand") && a("body").toggleClass("s1-expand").toggleClass("s1-collapse")
            })
        },
        dropdownMenu: function() {
            a(".nav ul.sub-menu").hide(), a(".nav li").hover(function() {
                a(this).children("ul.sub-menu").slideDown("fast")
            }, function() {
                a(this).children("ul.sub-menu").hide()
            })
        },
        mobileMenu: function() {
            function b(a) {
                var b = a.parent(),
                    c = a.outerHeight(!0),
                    d = b.height();
                b.toggleClass("expand"), b.hasClass("expand") ? setTimeout(function() {
                    b.addClass("transition").css("height", c)
                }, 10) : setTimeout(function() {
                    b.css("height", d), setTimeout(function() {
                        b.addClass("transition").css("height", 0)
                    }, 10)
                }, 10), b.one("transitionEnd webkitTransitionEnd transitionend oTransitionEnd msTransitionEnd", function() {
                    b.hasClass("open") && b.removeClass("transition").css("height", "auto")
                })
            }
            a(".nav-toggle").on("click", function() {
                b(a(".nav-wrap .nav", a(this).parent()))
            })
        },
        _has_iframe: function(a) {
            var b = [];
            return _.map(a, function(a, c) {
                a.length > 0 && a.find("IFRAME").length > 0 && b.push(c)
            }), b
        }
    };
    b.methods.Czr_UserExperience = {}, a.extend(b.methods.Czr_UserExperience, c)
}(jQuery, czrapp);
var czrapp = czrapp || {};
jQuery(function(a) {
    var b = {
        BrowserDetect: [],
        Czr_Plugins: ["imgSmartLoad", "extLinks", "parallax"],
        Czr_UserExperience: ["outline", "smoothScroll", "toggleHeaderSearch", "scrollToTop", "widgetTabs", "commentTabs", "tableStyle", "sidebarCollapse", "dropdownMenu", "mobileMenu"]
    };
    czrapp.cacheProp().emitCustomEvents().loadCzr(b)
});